using UnityEngine;
using static DataStore;

public class AnimDataBinding : MonoBehaviour
{
    [Header("Animator must contain 'time' property linked \nto Motion Time, and Animation loop set to false")]
    public string fieldName;
    public float mapping = 9000;
    private Animator anim;
    private AnimData animData;

    //TODO: disable Loop Time in animation and setup time property via script?

    private void Start()
    {
        animData = DataStore.GetInstance().GetAnimData(fieldName);
        anim = GetComponent<Animator>();
        anim.speed = 0;
    }
    
    private void Update()
    {
        float f = DataStore.GetInstance().GetFloat(animData);
        float nrmTime = f/mapping;
        //Debug.Log(nrmTime);
        anim.SetFloat("time", nrmTime);
    }
}